﻿//////////////////////////////////////////////
// LogManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkLog
{
	class Logger ;
}

/// Includes ---------------------------------

// nkInputs
#include "../Dll/DllDefines.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------
	
namespace nkInputs
{
	class DLL_INPUTS_EXPORT LogManager final : public nkCommon::MaybeSingletonClass<LogManager>
	{
		public :

			// Getters
			nkLog::Logger* getReceiver () const ;

			// Setters
			void setReceiver (nkLog::Logger* receiver) ;

			// Log
			void log (nkMemory::StringView message, nkMemory::StringView className) ;

		private :

			// Constructor, destructor
			LogManager (bool isSingleton) noexcept ;
			LogManager (const LogManager&) = delete ;
			LogManager (LogManager&&) = delete ;

			// Operators
			LogManager& operator= (const LogManager&) = delete ;
			LogManager& operator= (LogManager&&) = delete ;

		private :

			nkLog::Logger* _receiver ;

		private :

			friend class nkCommon::MaybeSingletonClass<LogManager> ;
			friend class System ;
	} ;
}